/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.availability;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CommonProxy;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityDialog;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityFaction;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityItemStacks;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityNames;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityQuest;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityRegions;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityScoreboard;
import noppes.npcs.client.gui.availability.SubGuiNpcAvailabilityStoredData;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumDayTime;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.Availability;

public class SubGuiNpcAvailability
extends SubGuiInterface
implements ISliderListener,
ITextfieldListener {
    public final Availability availability;
    public final GuiScreen parent;

    public SubGuiNpcAvailability(Availability availabilityIn, GuiScreen gui) {
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.parent = gui;
        this.availability = availabilityIn;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.setSubGui(new SubGuiNpcAvailabilityDialog(this.availability));
                break;
            }
            case 1: {
                this.setSubGui(new SubGuiNpcAvailabilityQuest(this.availability));
                break;
            }
            case 2: {
                this.setSubGui(new SubGuiNpcAvailabilityFaction(this.availability));
                break;
            }
            case 3: {
                this.setSubGui(new SubGuiNpcAvailabilityScoreboard(this.availability));
                break;
            }
            case 4: {
                this.availability.healthType = button.getValue();
                if (this.getSlider(5) == null) break;
                this.getSlider(5).setIsVisible(this.availability.healthType != 0);
                break;
            }
            case 6: {
                this.setSubGui(new SubGuiNpcAvailabilityNames(this.availability));
                break;
            }
            case 7: {
                this.setSubGui(new SubGuiNpcAvailabilityStoredData(this.availability));
                break;
            }
            case 8: {
                SubGuiNpcAvailabilityItemStacks.parent = this.parent;
                SubGuiNpcAvailabilityItemStacks.setting = this;
                CommonProxy.availabilityStacks.put((EntityPlayer)this.player, this.availability);
                NBTTagCompound compound = new NBTTagCompound();
                this.availability.save(compound);
                Client.sendData(EnumPacketServer.AvailabilityStacks, compound);
                NoppesUtil.requestOpenGUI(EnumGuiType.AvailabilityStack);
                break;
            }
            case 9: {
                this.setSubGui(new SubGuiNpcAvailabilityRegions(this.availability));
                break;
            }
            case 50: {
                if (button.getValue() == 0) {
                    this.getTextField(52).setFullText("" + this.availability.daytime[0]);
                    this.getTextField(53).setFullText("" + this.availability.daytime[1]);
                } else {
                    switch (EnumDayTime.values()[button.getValue() - 1]) {
                        case Always: {
                            this.getTextField(52).setFullText("0");
                            this.getTextField(53).setFullText("0");
                            break;
                        }
                        case Night: {
                            this.getTextField(52).setFullText("18");
                            this.getTextField(53).setFullText("6");
                            break;
                        }
                        case Day: {
                            this.getTextField(52).setFullText("6");
                            this.getTextField(53).setFullText("18");
                        }
                    }
                }
                this.availability.daytime[0] = this.getTextField(52).getInteger();
                this.availability.daytime[1] = this.getTextField(53).getInteger();
                break;
            }
            case 66: {
                this.close();
                break;
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        GuiNpcLabel label = new GuiNpcLabel(1, "availability.available", this.guiLeft, this.guiTop + 4);
        label.setCenter(this.xSize);
        this.addLabel(label);
        int x = this.guiLeft + 6;
        int y = this.guiTop + 14;
        int h = 18;
        GuiNpcButton button = new GuiNpcButton(0, x, y, 120, h, "availability.selectdialog");
        button.setHoverText("availability.hover.selectdialog", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, x, y += h + 2, 120, h, "availability.selectquest");
        button.setHoverText("availability.hover.selectquest", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, x, y += h + 2, 120, h, "availability.selectfaction");
        button.setHoverText("availability.hover.selectfaction", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(8, x, y + h + 2, 120, h, "availability.stack");
        button.setHoverText("availability.hover.stack", new Object[0]);
        this.addButton(button);
        y = this.guiTop + 14;
        button = new GuiNpcButton(3, x += 124, y, 120, h, "availability.selectscoreboard");
        button.setHoverText("availability.hover.selectscoreboard", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, x, y += h + 2, 120, h, "availability.selectnames");
        button.setHoverText("availability.hover.selectnames", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(7, x, y += h + 2, 120, h, "availability.storeddata");
        button.setHoverText("availability.hover.storeddata", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(9, x, y + h + 2, 120, h, "availability.region");
        button.setHoverText("availability.hover.region", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, this.guiLeft + 82, this.guiTop + 192, 98, h, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(50, "availability.daytime", this.guiLeft + 4, this.guiTop + 131));
        button = new GuiNpcButton(50, this.guiLeft + 70, this.guiTop + 126, 70, h, new String[]{"availability.own", "availability.always", "availability.night", "availability.day"}, this.availability.daytime[0] == this.availability.daytime[1] ? 1 : (this.availability.daytime[0] == 18 && this.availability.daytime[1] == 6 ? 2 : (this.availability.daytime[0] == 6 && this.availability.daytime[1] == 18 ? 3 : 1)));
        button.setHoverText("availability.hover.daytime.0", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(51, "availability.minlevel", this.guiLeft + 4, this.guiTop + 153));
        GuiNpcTextField textField = new GuiNpcTextField(51, this, this.field_146289_q, this.guiLeft + 70, this.guiTop + 149, 70, h - 2, this.availability.minPlayerLevel + "");
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, 0L);
        textField.setHoverText("availability.hover.level", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(52, this, this.field_146289_q, this.guiLeft + 145, this.guiTop + 127, 40, h - 2, this.availability.daytime[0] + "");
        textField.setMinMaxDefault(0L, 23L, this.availability.daytime[0]);
        textField.setHoverText("availability.hover.daytime.1", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(53, this, this.field_146289_q, this.guiLeft + 190, this.guiTop + 127, 40, h - 2, this.availability.daytime[1] + "");
        textField.setMinMaxDefault(0L, 23L, this.availability.daytime[1]);
        textField.setHoverText("availability.hover.daytime.2", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(52, "availability.health", this.guiLeft + 4, this.guiTop + 175));
        button = new GuiNpcButton(4, this.guiLeft + 70, this.guiTop + 170, 70, h, new String[]{"availability.always", "availability.bigger", "availability.smaller"}, this.availability.healthType);
        button.setHoverText("availability.hover.health.type", new Object[0]);
        this.addButton(button);
        GuiNpcSlider slider = new GuiNpcSlider(this, 5, this.guiLeft + 145, this.guiTop + 170, (float)this.availability.health / 100.0f);
        slider.field_146120_f = 106;
        slider.field_146125_m = this.availability.healthType != 0;
        slider.setHoverText("availability.hover.health", new Object[0]);
        this.addSlider(slider);
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        this.availability.health = (int)(slider.getSliderValue() * 100.0f);
        slider.setString(this.availability.health + "%");
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    @Override
    public void save() {
        this.availability.minPlayerLevel = this.getTextField(51).getInteger();
        this.availability.daytime[0] = this.getTextField(52).getInteger();
        this.availability.daytime[1] = this.getTextField(53).getInteger();
    }

    @Override
    public void unFocused(IGuiNpcTextField textfield) {
        switch (textfield.getID()) {
            case 51: {
                this.availability.minPlayerLevel = textfield.getInteger();
                break;
            }
            case 52: {
                this.availability.daytime[0] = textfield.getInteger();
                break;
            }
            case 53: {
                this.availability.daytime[1] = textfield.getInteger();
            }
        }
    }
}

